"use strict";(self["webpackJsonp-desktop-app"]=self["webpackJsonp-desktop-app"]||[]).push([[53377],{wNmz:t=>{t.exports=JSON.parse('{"tutorials":[{"surfaces":{"help_json":{"format":"helpjson","title":"Edit text in PDFs","version":"1.0","attrs":{"url":"https://helpx.adobe.com/acrobat/using/edit-text-pdfs.html","date":"2023-04-11"},"contents":[{"node_type":"Title","text":"Edit text in PDFs"},{"node_type":"Text","text":"Learn how to add or replace text and fix typos in a PDF using Acrobat. Change fonts and typeface. Adjust text size and alignment in a PDF.","data":[]},{"node_type":"ImageAndText","items":[{"data":[{"id":"<id_0>","text":"Before you begin","type":"strong"}],"node_type":"Text","text":"<id_0>"},{"data":[{"id":"<id_0>","text":"help for the new experience","type":"anchor","url":"?screen=modern"}],"node_type":"Text","text":"We are rolling out a new, more intuitive product experience. If the screen shown here doesn’t match your product interface, switch to the <id_0>."}],"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/current-view-reader.jpg"},{"node_type":"SectionTitle","text":"Watch a quick video tutorial and get started","anchorId":"watch"},{"node_type":"Video","author":"","caption":"","description":"","link":[{"format":"mpeg-ts","resolution":"1080p","url":"https://images-tv.adobe.com/mpcv3/4333/16723a5a-9af5-46f9-a54b-2010537943e3_1628056829.1920x1080at3000_h264.m3u8"},{"format":"playlist","resolution":"HLS","url":"https://images-tv.adobe.com/mpcv3/4333/f37cd2c1-595a-4a94-a55b-d9c0005ded77-1628056829-playlist.m3u8"},{"format":"mpeg-ts","resolution":"HD","url":"https://images-tv.adobe.com/mpcv3/4333/16723a5a-9af5-46f9-a54b-2010537943e3_1628056829.1280x720at2000_h264.m3u8"},{"format":"mpeg-ts","resolution":"High","url":"https://images-tv.adobe.com/mpcv3/4333/16723a5a-9af5-46f9-a54b-2010537943e3_1628056829.960x540at1200_h264.m3u8"},{"format":"mpeg4","resolution":"Medium","url":"https://images-tv.adobe.com/mpcv3/4333/16723a5a-9af5-46f9-a54b-2010537943e3_1628056829.854x480at800_h264.mp4"},{"format":"mpeg-ts","resolution":"Medium","url":"https://images-tv.adobe.com/mpcv3/4333/16723a5a-9af5-46f9-a54b-2010537943e3_1628056829.854x480at800_h264.m3u8"},{"format":"mpeg-ts","resolution":"Low","url":"https://images-tv.adobe.com/mpcv3/4333/16723a5a-9af5-46f9-a54b-2010537943e3_1628056829.640x360at400_h264.m3u8"}],"originalUrl":"https://video.tv.adobe.com/v/335905","source":"helpx","thumbnail":"https://images-tv.adobe.com/mpcv3/c0325860-2e49-40ce-9ea2-be2a6f0955fc/f37cd2c1-595a-4a94-a55b-d9c0005ded77/5af7aea8e08d4c9ebcdb91f1a160834b_1628056868-1920x1080.jpg","title":"","translations":[],"website":""},{"node_type":"SectionTitle","text":"Add, change, format, delete, or highlight text","anchorId":"edit-text"},{"node_type":"Accordion","items":[{"contents":[{"items":[{"data":[],"node_type":"Text","text":"When you edit text, the text in the paragraph reflows within its text box to accommodate the changes. Each text box is independent, and inserting text in one text block does not push down an adjacent text box or reflow to the next page."},{"node_type":"Procedure","steps":[{"items":[{"data":[{"id":"<id_0>","text":"Tools","type":"strong"},{"id":"<id_1>","text":"Edit PDF","type":"strong"},{"id":"<id_2>","text":"Edit","type":"strong"},{"height":21,"id":"<id_3>","type":"img","url":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/Edit-text-and-image_icon.png","local_source":"Edit_PDF/Cards/Card1/Card1Icon1.png","width":21}],"node_type":"Text","text":"Choose <id_0> > <id_1> > <id_2> <id_3>."},{"caption":"The dotted outlines identify the text and images you can edit.","height":1150,"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/edit-text-pdfs/jcr_content/main-pars/accordion_container_/accordion-par/accordion_item_1_cop/accordion-item-par/procesure_0/proc_par/step_0/step_par/image/edit-text.png","local_source":"Edit_PDF/Cards/Card1/Card1.1.png","node_type":"Image","width":1520}],"node_type":"Mixed"},{"items":[{"data":[],"node_type":"Text","text":"Select the text you want to edit. The text-box turns blue upon selection, and a rotation handle appears at the top of the selected text-box."},{"caption":"","height":652,"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/edit-text-pdfs/jcr_content/main-pars/accordion_container_/accordion-par/accordion_item_1_cop/accordion-item-par/procesure_0/proc_par/step_1/step_par/image/edit.png","local_source":"Edit_PDF/Cards/Card1/Card1.2.png","node_type":"Image","width":1486}],"node_type":"Mixed"},{"items":[{"data":[],"node_type":"Text","text":"Edit the text by doing one of the following:"},{"items":[{"data":[{"id":"<id_0>","text":"Delete","type":"strong"}],"node_type":"Text","text":"Type new text to replace the selected text, or press <id_0> to remove it."},{"data":[],"node_type":"Text","text":"To rotate the text box, use the rotation handle at the top of the selected text box."},{"data":[{"id":"<id_0>","text":"Format","type":"option"}],"node_type":"Text","text":"Manage list items using the list controls (bulleted and numbered) in the right-side <id_0> panel. You can create list items, convert an existing paragraph to a list item, convert an existing list item to a paragraph, and convert from one list type to another."},{"data":[{"id":"<id_0>","text":"Format","type":"strong"}],"node_type":"Text","text":"Select a font, font size, or other formatting options in the right-side <id_0> panel. You can also use the advanced format options, such as line spacing, character spacing, horizontal scaling, stroke width, and color."}],"node_type":"UnorderedList"},{"caption":"Formatting options in the right pane","height":318,"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/edit-text-pdfs/jcr_content/main-pars/procesure_0/proc_par/step_2/step_par/image_0/format_panel.png","local_source":"Edit_PDF/Cards/Card1/Card1.3.png","node_type":"Image","width":225},{"node_type":"Note","paragraphs":[{"data":[],"node_type":"Text","text":"For legal reasons, you must have purchased a font and have it installed on your system to revise text using that font."},{"data":[],"node_type":"Text","text":"You can edit text only if the font used for that text is installed on your system. If the font isn’t installed on your system, but is embedded in the PDF, you can change only the color or font size. If the font is not installed or embedded, you can\'t edit any of the text."}],"title":"Note:","type":"note"}],"node_type":"Mixed"},{"data":[],"node_type":"Text","text":"Click outside the selection to deselect it and start over."}]}],"node_type":"Mixed"}],"title":"Edit text - change, replace, or delete text"},{"contents":[{"items":[{"data":[{"id":"<id_0>","text":"Minion Pro","type":"italic"}],"node_type":"Text","text":"When you add text in a PDF, by default Acrobat picks nearby font attributes for the new text. Similarly, when you edit existing text in a PDF and the font is not available on the system, by default the font fall-backs to a specific font in a particular script. For example, font fall-backs to <id_0> in roman script fonts. This default behavior can lead to fonts with an inconsistent appearance in a PDF document. To make it consistent throughout all the PDFs, you can choose a specific font for both adding text and editing text using the Font Options under the Content Editing preferences."},{"node_type":"Procedure","steps":[{"data":[{"id":"<id_0>","text":"Edit","type":"strong"},{"id":"<id_1>","text":"Preferences","type":"strong"},{"id":"<id_2>","type":"br"},{"id":"<id_3>","text":"Ctrl+K","type":"option"},{"id":"<id_4>","text":"Command+K","type":"option"}],"node_type":"Text","text":"In Acrobat, on the <id_0> menu, choose <id_1>. The Preferences dialog box is displayed.<id_2> (Alternatively, you can press <id_3> keys on Windows or <id_4> keys on macOS.)"},{"items":[{"data":[{"id":"<id_0>","text":"Content Editing","type":"strong"}],"node_type":"Text","text":"In the dialog box, click <id_0> under Categories. The Font Options are displayed as shown in the screenshot below."},{"caption":"","height":419,"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/edit-text-pdfs/jcr_content/main-pars/accordion_container_/accordion-par/accordion_item_270710820/accordion-item-par/procedure/proc_par/step_0/step_par/image/Font_Options.png","local_source":"Edit_PDF/Cards/Card2/Card2.1.png","node_type":"Image","width":811}],"node_type":"Mixed"},{"items":[{"data":[],"node_type":"Text","text":"Select an appropriate font in the drop-down lists:"},{"items":[{"data":[{"id":"<id_0>","text":"Fallback Font for Editing","type":"strong"}],"node_type":"Text","text":"<id_0>"},{"data":[{"id":"<id_0>","text":"Default Font for Add Text","type":"strong"},{"id":"<id_1>","text":"Font Size","type":"strong"}],"node_type":"Text","text":"<id_0> and <id_1>"}],"node_type":"UnorderedList"}],"node_type":"Mixed"},{"data":[{"id":"<id_0>","text":"OK","type":"strong"}],"node_type":"Text","text":"Click <id_0> to save the changes and close the Preferences dialog box."}]}],"node_type":"Mixed"}],"title":"Set the default font for adding and editing text"},{"contents":[{"node_type":"Procedure","steps":[{"items":[{"data":[{"id":"<id_0>","text":"Tools","type":"strong"},{"id":"<id_1>","text":"Edit PDF","type":"strong"},{"id":"<id_2>","text":"Edit","type":"strong"},{"height":21,"id":"<id_3>","type":"img","url":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/Edit-text-and-image_icon.png","local_source":"Edit_PDF/Cards/Card3/Card3Icon1.png","width":21}],"node_type":"Text","text":"Choose <id_0> > <id_1> > <id_2> <id_3>."},{"caption":"The dotted outlines identify the text and images you can edit.","height":1150,"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/edit-text-pdfs/jcr_content/main-pars/accordion_container_/accordion-par/accordion_item_1_cop/accordion-item-par/procesure_0/proc_par/step_0/step_par/image/edit-text.png","local_source":"Edit_PDF/Cards/Card3/Card3.1.png","node_type":"Image","width":1520}],"node_type":"Mixed"},{"data":[],"node_type":"Text","text":"Select the text you want to change."},{"items":[{"data":[{"id":"<id_0>","text":"Format","type":"strong"}],"node_type":"Text","text":"In the right-side <id_0> panel, select a font, font size, or other formatting options. You can also use the advanced format options, such as line spacing, character spacing, horizontal scaling, stroke width, and color."},{"caption":"Formatting options in the right pane","height":318,"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/edit-text-pdfs/jcr_content/main-pars/procesure_0/proc_par/step_2/step_par/image_0/format_panel.png","local_source":"Edit_PDF/Cards/Card3/Card3.2.png","node_type":"Image","width":225},{"node_type":"Note","paragraphs":[{"data":[],"node_type":"Text","text":"For legal reasons, you must have purchased a font and have it installed on your system to revise text using that font."},{"data":[],"node_type":"Text","text":"You can edit text only if the font used for that text is installed on your system. If the font isn’t installed on your system, but is embedded in the PDF, you can change only the color or font size. If the font is not installed or embedded, you can\'t edit any of the text."}],"title":"Note:","type":"note"}],"node_type":"Mixed"},{"data":[],"node_type":"Text","text":"Click outside the selection to deselect it and start over."}]}],"title":"Format text - Change font, size, line spacing, character spacing, horizontal scaling, stroke width, or color"},{"contents":[{"items":[{"data":[],"node_type":"Text","text":"You can add or insert new text into a PDF using any of the fonts installed on the system."},{"node_type":"Procedure","steps":[{"items":[{"data":[{"id":"<id_0>","text":"Tools","type":"strong"},{"id":"<id_1>","text":"Edit PDF","type":"option"},{"id":"<id_2>","text":"Add Text","type":"strong"},{"height":21,"id":"<id_3>","type":"img","url":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/Add-text-icon.png","local_source":"Edit_PDF/Cards/Card4/Card4Icon1.png","width":21}],"node_type":"Text","text":"Select <id_0> > <id_1> > <id_2> <id_3>."},{"caption":"Open a PDF and then choose Tools > Edit PDF > Add text.","height":47,"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/edit-text-pdfs/jcr_content/main-pars/procesure_3/proc_par/step_0/step_par/image/Add-text-tool.png","local_source":"Edit_PDF/Cards/Card4/Card4.1.png","node_type":"Image","width":422}],"node_type":"Mixed"},{"data":[],"node_type":"Text","text":"Drag to define the width of the text block you want to add."},{"data":[{"id":"<id_0>","text":"Make Text Direction Vertical","type":"strong"}],"node_type":"Text","text":"For vertical text, right-click the text box, and choose <id_0>."},{"items":[{"items":[{"data":[],"node_type":"Text","text":"The Add text tool intelligently detects the following text properties of text close to the point of click:"},{"items":[{"data":[],"node_type":"Text","text":"Font name, size, and color"},{"data":[],"node_type":"Text","text":"Character, paragraph, and line spacing"},{"data":[],"node_type":"Text","text":"Horizontal scaling"}],"node_type":"UnorderedList"},{"data":[],"node_type":"Text","text":"These text properties are automatically applied to the text that you add at the point of click."}],"node_type":"Mixed"},{"data":[{"id":"<id_0>","text":"Format","type":"strong"}],"node_type":"Text","text":"You can change the text properties using the options under <id_0> in the right pane."}],"node_type":"Mixed"},{"data":[],"node_type":"Text","text":"Type the text."},{"data":[],"node_type":"Text","text":"To resize the text box, drag a selection handle."},{"data":[{"id":"<id_0>","text":"Move","type":"option"},{"height":16,"id":"<id_1>","type":"img","url":"https://helpx.adobe.com/content/dam/help/icons/Cursor_Grow_Away.png","local_source":"Edit_PDF/Cards/Card4/Card4Icon2.png","width":16}],"node_type":"Text","text":"To move the text box, place the pointer over the line of the bounding box (avoid the selection handles). When the cursor changes to <id_0> pointer <id_1>, drag the box to the new location. To maintain alignment with the other list items, press Shift as you drag."}]}],"node_type":"Mixed"}],"title":"Add new text"},{"contents":[{"items":[{"items":[{"data":[{"id":"<id_0>","text":"Edit Text & Images tool","type":"option"}],"node_type":"Text","text":"You can move or rotate text boxes on a page. The <id_0> outlines each text box, so it is clear what text is affected. Edits are confined to the page. You cannot drag a text block to another page, or move or rotate individual characters or words within a text box. However, you can copy text boxes and paste them on another page."},{"data":[],"node_type":"Text","text":"Resizing a text box causes the text to reflow within the new text box boundaries. It does not change the size of the text. As with other text edits, resizing is limited to the current page. Text does not flow to the next page."}],"node_type":"Mixed"},{"node_type":"Procedure","steps":[{"data":[{"id":"<id_0>","text":"Tools","type":"strong"},{"id":"<id_1>","text":"Edit PDF","type":"strong"},{"id":"<id_2>","text":"Edit","type":"strong"},{"height":21,"id":"<id_3>","type":"img","url":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/Edit-text-and-image_icon.png","local_source":"Edit_PDF/Cards/Card5/Card5Icon1.png","width":21}],"node_type":"Text","text":"Select <id_0> > <id_1> > <id_2> <id_3>."},{"items":[{"data":[],"node_type":"Text","text":"Click the text box you want to move, rotate, or resize."},{"caption":"A bounding box with selection handles surrounds the text box you clicked.","height":652,"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/edit-text-pdfs/jcr_content/main-pars/accordion_container_/accordion-par/accordion_item_1_cop/accordion-item-par/procesure_0/proc_par/step_1/step_par/image/edit.png","local_source":"Edit_PDF/Cards/Card5/Card5.1.png","node_type":"Image","width":1486}],"node_type":"Mixed"},{"items":[{"data":[],"node_type":"Text","text":"Do any of the following:"},{"items":[{"data":[{"id":"<id_0>","text":"Move","type":"option"},{"height":16,"id":"<id_1>","type":"img","url":"https://helpx.adobe.com/content/dam/help/icons/Cursor_Grow_Away.png","local_source":"Edit_PDF/Cards/Card5/Card5Icon2.png","width":16}],"node_type":"Text","text":"Place the pointer over the line of the bounding box (avoid the selection handles). When the cursor changes to <id_0> pointer <id_1>, drag the box to the desired location. Hold down the Shift key as you drag to constrain the movement vertically or horizontally."}],"name":"Move","node_type":"Variable"},{"caption":"","height":287,"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/edit-text-pdfs/jcr_content/main-pars/accordion_container_/accordion-par/accordion-item-2/accordion-item-par/procedure/proc_par/step_2/step_par/image/move-sm.png","local_source":"Edit_PDF/Cards/Card5/Card5.2.png","node_type":"Image","width":454},{"items":[{"data":[{"id":"<id_0>","text":"Rotation","type":"option"},{"height":23,"id":"<id_1>","type":"img","url":"https://helpx.adobe.com/content/dam/help/icons/Cur_ObjectRotate.png","width":23}],"node_type":"Text","text":"Click and hold the <id_0> pointer <id_1>, drag in the direction you want it to rotate."}],"name":"Rotate","node_type":"Variable"},{"caption":"","height":404,"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/edit-text-pdfs/jcr_content/main-pars/accordion_container_/accordion-par/accordion-item-2/accordion-item-par/procedure/proc_par/step_2/step_par/image_0/rotate-sm.png","local_source":"Edit_PDF/Cards/Card5/Card5.3.png","node_type":"Image","width":454},{"items":[{"data":[],"node_type":"Text","text":"Place the pointer over any of the circular selection handles, and drag the handle to resize the text block."}],"name":"Resize","node_type":"Variable"},{"caption":"","height":306,"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/edit-text-pdfs/jcr_content/main-pars/accordion_container_/accordion-par/accordion-item-2/accordion-item-par/procedure/proc_par/step_2/step_par/image_1/resize-sm.png","local_source":"Edit_PDF/Cards/Card5/Card5.4.png","node_type":"Image","width":454}],"node_type":"Mixed"}]}],"node_type":"Mixed"}],"title":"Move, rotate, or resize a textbox"},{"contents":[{"items":[{"data":[],"node_type":"Text","text":"You can add items to a numbered or bulleted list, create list items, convert an existing paragraph to a list item, convert an existing list item to a paragraph, and convert from one list type to another."},{"node_type":"Procedure","steps":[{"items":[{"data":[{"id":"<id_0>","text":"Tools","type":"strong"},{"id":"<id_1>","text":"Edit PDF","type":"strong"},{"id":"<id_2>","text":"Edit","type":"strong"},{"height":21,"id":"<id_3>","type":"img","url":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/Edit-text-and-image_icon.png","local_source":"Edit_PDF/Cards/Card6/Card6Icon1.png","width":21}],"node_type":"Text","text":"Select <id_0> > <id_1> > <id_2> <id_3>."},{"data":[],"node_type":"Note","paragraphs":[{"data":[],"node_type":"Text","text":"Acrobat detects paragraphs and lists separately. Therefore, both paragraph and list may appear in the same bounding box while editing. After you save or save as the changed file and reopen it, the paragraph and list items are displayed in separate bounding boxes."}],"title":"Note:","type":"note"}],"node_type":"Mixed"},{"items":[{"items":[{"data":[],"node_type":"Text","text":"Do the following:"},{"data":[],"node_type":"Text","text":"To add or remove items from a numbered or bulleted list:"},{"items":[{"data":[{"id":"<id_0>","text":"Enter","type":"option"},{"id":"<id_1>","text":"Backspace","type":"option"}],"node_type":"Text","text":"You can add or remove items to the list at all nested levels using the same familiar controls that you use in MS Office. For example, press <id_0> at the end of a list item to insert a new row. Press <id_1> to remove the new row and position the cursor back to the end of the previous list item."}],"node_type":"UnorderedList"}],"node_type":"Mixed"},{"items":[{"data":[],"node_type":"Text","text":"To create a numbered or bulleted list:"},{"items":[{"data":[],"node_type":"Text","text":"Place the cursor in the document at the location where you want to add a list."},{"data":[{"id":"<id_0>","text":"Format","type":"strong"}],"node_type":"Text","text":"Choose the appropriate list type (bulleted or numbered) under <id_0> in the right pane."}],"node_type":"OrderedList"},{"data":[],"node_type":"Text","text":"To convert an existing paragraph to a list item:"},{"items":[{"data":[{"id":"<id_0>","text":"Format","type":"option"}],"node_type":"Text","text":"Place the cursor in the paragraph, and then choose the appropriate list type (bulleted or numbered) under <id_0> in the right pane."}],"node_type":"UnorderedList"},{"data":[],"node_type":"Text","text":"To convert an existing list item to a paragraph:"},{"items":[{"data":[{"id":"<id_0>","text":"Format","type":"option"}],"node_type":"Text","text":"Select all items in the list. The appropriate list type is highlighted under <id_0> in the right pane."},{"data":[],"node_type":"Text","text":"Click the highlighted list type."}],"node_type":"OrderedList"},{"data":[],"node_type":"Text","text":"To convert from one list type to another:"},{"items":[{"data":[],"node_type":"Text","text":"Place the cursor in the list item or select all items in the list."},{"data":[{"id":"<id_0>","text":"Format","type":"option"}],"node_type":"Text","text":"Choose the appropriate list type (bulleted or numbered) under <id_0> in the right pane."}],"node_type":"OrderedList"}],"node_type":"Mixed"},{"caption":"Formatting options in the right pane","height":318,"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/edit-text-pdfs/jcr_content/main-pars/procesure_2/proc_par/step_1/step_par/multi_column/col-50-50-c2/image/format_list_types.png","local_source":"Edit_PDF/Cards/Card6/Card6.1.png","node_type":"Image","width":225},{"data":[],"node_type":"Note","paragraphs":[{"data":[],"node_type":"Text","text":"You can also use Keyboard to add a list item. For example, before a paragraph, you can type number ‘a’ followed by the closing parenthesis ‘)’ and then add one space. It adds a numbered list starting with “a)”."}],"title":"Note:","type":"note"}],"node_type":"Mixed"}]}],"node_type":"Mixed"}],"title":"Add or edit a numbered or bulleted list"},{"contents":[{"items":[{"data":[{"id":"<id_0>","text":"Contact the creator or the author of the PDF to get the password to edit the PDFs","type":"strong"}],"node_type":"Text","text":"You can limit access to a PDF by setting passwords and by restricting certain features, such as printing and editing. You can remove security from a PDF if you have the document password. If the PDF is secured with a server-based security policy, only the policy author or a server administrator can change it. <id_0>."},{"data":[],"node_type":"Text","text":"When you try to edit a password protected PDF, you get the following error."},{"node_type":"Image","caption":"","height":213,"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/kb/edit-secured-pdf/cannot-edit-a-secure-document.png","local_source":"Edit_PDF/Cards/Card7/Card7.1.png","width":629},{"node_type":"SubSubSectionTitle","text":"Steps to remove password security"},{"data":[],"node_type":"Text","text":"If you have the document password, follow the steps below to remove security from the PDF."},{"node_type":"Procedure","steps":[{"data":[],"node_type":"Text","text":"Open the PDF in Acrobat."},{"data":[{"id":"<id_0>","text":"Tools","type":"option"},{"id":"<id_1>","text":"Protect","type":"option"},{"id":"<id_2>","text":"Encrypt","type":"option"},{"id":"<id_3>","text":"Remove Security","type":"option"}],"node_type":"Text","text":"Select <id_0> > <id_1> > <id_2> > <id_3>."},{"items":[{"data":[],"node_type":"Text","text":"Your options vary depending on the type of password security attached to the document:"},{"items":[{"data":[{"id":"<id_0>","text":"Document Open","type":"strong"},{"id":"<id_1>","text":"OK","type":"strong"}],"node_type":"Text","text":"If the document has a <id_0> password, click <id_1> to remove it from the document."},{"data":[{"id":"<id_0>","text":"Enter Password","type":"strong"},{"id":"<id_1>","text":"OK.","type":"strong"},{"id":"<id_2>","text":"OK","type":"strong"}],"node_type":"Text","text":"If the document has a permissions password, type it in the <id_0> box and then click <id_1> Click <id_2> again to confirm the action."}],"node_type":"UnorderedList"},{"data":[],"node_type":"Text","text":"You can now edit the PDF."}],"node_type":"Mixed"}]},{"node_type":"SubSubSectionTitle","text":"Forgot the document or permissions password?"},{"items":[{"data":[],"node_type":"Text","text":"If you are the owner of a PDF and don\'t remember the password required to open the PDF, you have to re-create the PDF. There is no way to recover the password in Acrobat."},{"data":[],"node_type":"Text","text":"If you are the owner of a PDF and have forgotten the permissions password used to restrict certain features in the PDF, follow the workaround below to make the PDF editable by printing a copy."}],"node_type":"UnorderedList"},{"data":[],"node_type":"Caution","text":"Printing a file to PDF using the Adobe PDF printer removes interactive elements in the printed file, such as bookmarks, hyperlinks, and buttons.","title":"Caution:","type":"caution"},{"node_type":"Procedure","steps":[{"data":[],"node_type":"Text","text":"Open the PDF in Acrobat."},{"data":[{"id":"<id_0>","text":"File > Print","type":"strong"},{"id":"<id_1>","text":"Printer","type":"strong"},{"height":21,"id":"<id_2>","type":"img","url":"https://helpx.adobe.com/content/dam/help/en/acrobat/kb/edit-pdf/printer-icon.png","local_source":"Edit_PDF/Cards/Card7/Card7Icon1.png","width":22}],"node_type":"Text","text":"Go to <id_0> or click the <id_1> <id_2> icon in the toolbar."},{"data":[{"id":"<id_0>","text":"Adobe PDF","type":"strong"},{"id":"<id_1>","text":"Print","type":"strong"}],"node_type":"Text","text":"In the Print dialog box, choose <id_0> as the printer and click <id_1>."},{"items":[{"data":[{"id":"<id_0>","text":"Save","type":"strong"}],"node_type":"Text","text":"Type a name for your file and click <id_0>. The PDF is created, and it opens in Acrobat."},{"data":[],"node_type":"Text","text":"You can now edit the PDF."}],"node_type":"Mixed"}]}],"node_type":"Mixed"}],"title":"Edit password protected PDFs"}]},{"node_type":"SectionTitle","text":"Edit a PDF form","anchorId":"edit-form"},{"node_type":"Accordion","items":[{"contents":[{"data":[{"id":"<id_0>","text":"Fill and sign your PDF form","type":"anchor","url":"https://helpx.adobe.com/content/help/en/acrobat/using/fill-and-sign.html#fill_your_PDF_form"}],"node_type":"Text","text":"You can use the Fill & Sign tools to add text and other symbols anywhere on the form. For instructions, see <id_0>."}],"title":"Add, edit, or move text in a PDF form"},{"contents":[{"data":[{"id":"<id_0>","text":"PDF forms help","type":"anchor","url":"https://helpx.adobe.com/content/help/en/acrobat/using/pdf-forms.html"}],"node_type":"Text","text":"You can create, distribute, track, fill, and sign PDF forms using Acrobat. For more information, see <id_0>."}],"title":"Create or edit a PDF form"}]},{"node_type":"SectionTitle","text":"Rotate, move, delete, extract, or renumber PDF pages","anchorId":"RotatemovedeleteextractorrenumberPDFpages"},{"node_type":"Text","text":"You can easily organize pages in a PDF if you have permission to <id_0>. For more information, see <id_1>.","data":[{"id":"<id_0>","type":"anchor","text":"edit the PDF","url":"https://www.adobe.com/acrobat/online/pdf-editor.html"},{"id":"<id_1>","type":"anchor","text":"Rotate, move, delete, extract, or renumber PDF pages","url":"https://helpx.adobe.com/content/help/en/acrobat/using/manipulating-deleting-renumbering-pdf-pages.html"}]},{"node_type":"SectionTitle","text":"Update headers, footers, background, or watermarks","anchorId":"headers-footers"},{"node_type":"Accordion","items":[{"contents":[{"data":[{"id":"<id_0>","text":"Add headers, footers, and Bates numbering to PDFs","type":"anchor","url":"https://helpx.adobe.com/content/help/en/acrobat/using/add-headers-footers-pdfs.html"},{"id":"<id_1>","type":"br"}],"node_type":"Text","text":"Acrobat lets you add a header and footer throughout a PDF. Headers and footers can include a date, automatic page numbering, Bates numbers for legal documents, or the title and author. For more information, see <id_0>.<id_1>"}],"title":"Add or update headers and footers"},{"contents":[{"data":[{"id":"<id_0>","text":"Add backgrounds to PDFs","type":"anchor","url":"https://helpx.adobe.com/content/help/en/acrobat/using/add-backgrounds-pdfs.html"}],"node_type":"Text","text":"You can selectively apply a background to only specific pages or page ranges in one or more PDFs. A PDF supports only one background per page, but the backgrounds can vary from page to page. For more information, see <id_0>."}],"title":"Add, replace, or edit a background"},{"contents":[{"data":[{"id":"<id_0>","text":"Add watermarks to PDFs","type":"anchor","url":"https://helpx.adobe.com/content/help/en/acrobat/using/add-watermarks-pdfs.html"}],"node_type":"Text","text":"A watermark is a text or an image that appears either in front of or behind existing document content, like a stamp. For example, you could apply a “Confidential” watermark to pages with sensitive information. You can add multiple watermarks to one or more PDFs, but you must add each watermark separately. For more information, see <id_0>."}],"title":"Add watermarks"}]},{"node_type":"ImageAndText","items":[{"data":[{"id":"<id_0>","text":"Before you begin","type":"strong"}],"node_type":"Text","text":"<id_0>"},{"data":[{"id":"<id_0>","text":"help for your current experience","type":"anchor","url":"?screen=classic"}],"node_type":"Text","text":"We are rolling out a new, more intuitive product experience. If the screen shown here doesn’t match your product interface, switch to the <id_0>."}],"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/modern-view-reader.jpg"},{"node_type":"Mixed","items":[{"data":[{"id":"<id_0>","text":"Edit","type":"option"}],"node_type":"Text","text":"Open the PDF you want to edit in Acrobat, and then select <id_0> in the mega verb bar."},{"caption":"","height":192,"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/edit-pdfs-new-experience/edit.png","node_type":"Image","width":2504},{"data":[],"node_type":"Text","text":"The PDF switches to the edit mode, and the Edit panel displays. If the PDF is generated from a scanned document, Acrobat automatically runs OCR to make the text and images editable."},{"caption":"","height":1842,"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/edit-pdfs-new-experience/edit-panel.png","node_type":"Image","width":2510},{"data":[{"id":"<id_0>","type":"br"}],"node_type":"Text","text":"The Edit panel includes options to modify the page, add content, redact a PDF, and convert various documents to PDF forms. You can use the options in the Edit panel to replace, edit, or add text to a PDF. You can correct typos, change fonts and typeface size, adjust alignment, add superscripts or subscripts, and resize text or paragraphs.<id_0>"}]},{"node_type":"SectionTitle","text":"Add, change, format, delete, or highlight text","anchorId":"edit-text"},{"node_type":"Accordion","items":[{"contents":[{"items":[{"data":[{"id":"<id_0>","text":"Minion Pro","type":"italic"}],"node_type":"Text","text":"When you add text in a PDF, by default Acrobat chooses nearby font attributes for the new text. When you edit text, any font that isn\'t available on the system is substituted by a default fall-back font for the particular script. For example, <id_0> is the default fall-back font for Roman script fonts. The substitution of unavailable fonts by default fonts can introduce inconsistency in the look and feel of text in a PDF document. To avoid inconsistency, choose a specific font for any text that is added or modified in the PDF document from Font Options under Content Editing."},{"node_type":"Procedure","steps":[{"data":[{"height":12,"id":"<id_0>","type":"img","url":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/modern-viewer/organize-pages-new-experience/hamburger-icon-sm.png","width":12},{"id":"<id_1>","text":"Preferences","type":"strong"},{"id":"<id_2>","type":"br"},{"id":"<id_3>","text":"Ctrl+K","type":"option"},{"id":"<id_4>","text":"Command+K","type":"option"}],"node_type":"Text","text":"From the hamburger menu <id_0>, choose <id_1>. The Preferences dialog box is displayed.<id_2> (Alternatively, you can press <id_3> keys on Windows® or <id_4> keys on macOS.)"},{"items":[{"data":[{"id":"<id_0>","text":"Content Editing","type":"option"}],"node_type":"Text","text":"In the dialog box, select <id_0> under Categories. Font Options are displayed as shown in the following screenshot."},{"caption":"","height":419,"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/edit-text-pdfs/jcr_content/main-pars/accordion_container_/accordion-par/accordion_item_270710820/accordion-item-par/procedure/proc_par/step_0/step_par/image/Font_Options.png","node_type":"Image","width":811}],"node_type":"Mixed"},{"items":[{"data":[],"node_type":"Text","text":"Select an appropriate font in the drop-down lists:"},{"items":[{"data":[{"id":"<id_0>","text":"Fallback font for Editing","type":"strong"}],"node_type":"Text","text":"<id_0>."},{"data":[{"id":"<id_0>","text":"Default font for Add Text","type":"strong"},{"id":"<id_1>","text":"Font Size","type":"strong"}],"node_type":"Text","text":"<id_0> and <id_1>."}],"node_type":"UnorderedList"}],"node_type":"Mixed"},{"data":[{"id":"<id_0>","text":"OK","type":"strong"}],"node_type":"Text","text":"Click <id_0> to save the changes and close the Preferences dialog box."}]}],"node_type":"Mixed"}],"title":"Set the default font for adding and editing text"},{"contents":[{"items":[{"data":[],"node_type":"Text","text":"When you edit text, the text in the paragraph reflows within its text box to accommodate the changes. Each text box is independent, and inserting text in one text block doesn’t push down an adjacent text box or reflow to the next page."},{"node_type":"Procedure","steps":[{"items":[{"data":[{"id":"<id_0>","text":"Text","type":"option"},{"id":"<id_1>","text":"Add Content","type":"option"}],"node_type":"Text","text":"From the Edit panel, select <id_0> under <id_1>."},{"caption":"The dotted outlines identify the text and images that you can edit.","height":1150,"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/edit-text-pdfs/jcr_content/main-pars/accordion_container_/accordion-par/accordion_item_1_cop/accordion-item-par/procesure_0/proc_par/step_0/step_par/image/edit-text.png","node_type":"Image","width":1520}],"node_type":"Mixed"},{"items":[{"data":[],"node_type":"Text","text":"Select the text that you want to edit. The text-box turns blue upon selection, and a rotation handle appears at the top of the selected text-box."},{"caption":"","height":652,"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/edit-text-pdfs/jcr_content/main-pars/accordion_container_/accordion-par/accordion_item_1_cop/accordion-item-par/procesure_0/proc_par/step_1/step_par/image/edit.png","node_type":"Image","width":1486}],"node_type":"Mixed"},{"items":[{"data":[],"node_type":"Text","text":"Edit the text by doing one of the following:"},{"items":[{"data":[{"id":"<id_0>","text":"Delete","type":"strong"}],"node_type":"Text","text":"Type new text to replace the selected text, or press <id_0> to remove it."},{"data":[],"node_type":"Text","text":"To rotate the text box, use the rotation handle at the top of the selected text box."},{"data":[{"id":"<id_0>","text":"Format","type":"option"}],"node_type":"Text","text":"Manage list items using the list controls (bulleted and numbered) in the right-side <id_0> panel. You can create lists, and conversely, convert a list item to a paragraph, or change list types."},{"data":[{"id":"<id_0>","text":"Format","type":"strong"}],"node_type":"Text","text":"Select a font, font size, or other formatting options in the right-side <id_0> panel. You can also try the advanced format options, such as line spacing, character spacing, horizontal scaling, stroke width, and color."}],"node_type":"UnorderedList"},{"caption":"Formatting options in the right pane","height":407,"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/modern-viewer/Format-Text-Panel.png","node_type":"Image","width":378},{"node_type":"Note","paragraphs":[{"data":[],"node_type":"Text","text":"For legal reasons, you must have purchased a font and have it installed on your system to revise text using that font."},{"data":[],"node_type":"Text","text":"You can edit text only if the font used for that text is installed on your system. If the font isn’t installed, but is embedded in the PDF, you can only change the color or font size. If the font isn\'t installed or embedded, you can\'t edit any text."}],"title":"Note:","type":"note"}],"node_type":"Mixed"},{"data":[],"node_type":"Text","text":"Select any area outside the selection to deselect it, and start over."}]}],"node_type":"Mixed"}],"title":"Change, replace, or delete text"},{"contents":[{"node_type":"Procedure","steps":[{"items":[{"data":[{"id":"<id_0>","text":"Text","type":"option"},{"id":"<id_1>","text":"Add Content","type":"option"}],"node_type":"Text","text":"From the Edit panel, select <id_0> under <id_1>."},{"caption":"The dotted outlines identify the text and images that you can edit.","height":1150,"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/edit-text-pdfs/jcr_content/main-pars/accordion_container_/accordion-par/accordion_item_1_cop/accordion-item-par/procesure_0/proc_par/step_0/step_par/image/edit-text.png","node_type":"Image","width":1520}],"node_type":"Mixed"},{"data":[],"node_type":"Text","text":"Select the text that you want to change."},{"items":[{"data":[{"id":"<id_0>","text":"Format","type":"strong"}],"node_type":"Text","text":"In the right-side <id_0> panel, select a font, font size, or other formatting options. You can also try the advanced format options, such as line spacing, character spacing, horizontal scaling, stroke width, and color."},{"caption":"Formatting options in the right pane","height":407,"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/modern-viewer/Format-Text-Panel.png","node_type":"Image","width":378},{"node_type":"Note","paragraphs":[{"data":[],"node_type":"Text","text":"For legal reasons, you must have purchased a font and have it installed on your system to revise text using that font."},{"data":[],"node_type":"Text","text":"You can edit text only if the font used for that text is installed on your system. If the font isn’t installed on your system, but is embedded in the PDF, change only the color or font size. If the font isn\'t installed or embedded, you can\'t edit any text."}],"title":"Note:","type":"note"}],"node_type":"Mixed"},{"data":[],"node_type":"Text","text":"Select outside the selection to deselect it and start over."}]}],"title":"Format text"},{"contents":[{"items":[{"data":[],"node_type":"Text","text":"You can add or insert new text into a PDF using any of the fonts installed on the system."},{"node_type":"Procedure","steps":[{"data":[{"id":"<id_0>","text":"Text","type":"option"},{"id":"<id_1>","text":"Add Content","type":"option"}],"node_type":"Text","text":"From the Edit panel, select <id_0> under <id_1>."},{"data":[],"node_type":"Text","text":"Drag to define the width of the text block that you want to add."},{"items":[{"items":[{"data":[],"node_type":"Text","text":"The Add text tool intelligently detects the following text properties of text close to the point of click:"},{"items":[{"data":[],"node_type":"Text","text":"Font name, size, and color"},{"data":[],"node_type":"Text","text":"Character, paragraph, and line spacing"},{"data":[],"node_type":"Text","text":"Horizontal scaling"}],"node_type":"UnorderedList"},{"data":[],"node_type":"Text","text":"These text properties are automatically applied to the text that you add at the point of click."}],"node_type":"Mixed"},{"data":[{"id":"<id_0>","text":"Format","type":"strong"}],"node_type":"Text","text":"You can change the text properties using the options under <id_0> in the right pane."}],"node_type":"Mixed"},{"data":[],"node_type":"Text","text":"Type the text."},{"data":[],"node_type":"Text","text":"To resize the text box, drag a selection handle."},{"data":[{"id":"<id_0>","text":"Move","type":"option"},{"height":16,"id":"<id_1>","type":"img","url":"https://helpx.adobe.com/content/dam/help/icons/Cursor_Grow_Away.png","width":16}],"node_type":"Text","text":"To move the text box, place the pointer over the line of the bounding box (avoid the selection handles). When the cursor changes to <id_0> pointer <id_1>, drag the box to the new location. To maintain alignment with the other list items, press Shift as you drag."}]}],"node_type":"Mixed"}],"title":"Add new text"},{"contents":[{"items":[{"items":[{"data":[{"id":"<id_0>","text":"Edit Text tool","type":"option"}],"node_type":"Text","text":"You can move or rotate text boxes on a page. The <id_0> outlines each text box, so it\'s clear what text is affected. Edits are confined to the page. You can\'t drag a text block to another page, or move or rotate individual characters or words within a text box. However, you can copy text boxes and paste them on another page."},{"data":[],"node_type":"Text","text":"Resizing a text box causes the text to reflow within the new text box boundaries. It doesn\'t change the size of the text. As with other text edits, resizing is limited to the current page. Text doesn\'t flow to the next page."}],"node_type":"Mixed"},{"node_type":"Procedure","steps":[{"data":[{"id":"<id_0>","text":"Text","type":"option"},{"id":"<id_1>","text":"Add Content","type":"option"}],"node_type":"Text","text":"From the Edit panel, select <id_0> under <id_1>."},{"items":[{"data":[],"node_type":"Text","text":"Select the text box that you want to move, rotate, or resize."},{"caption":"A bounding box with selection handles surrounds the text box that you clicked.","height":652,"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/edit-text-pdfs/jcr_content/main-pars/accordion_container_/accordion-par/accordion_item_1_cop/accordion-item-par/procesure_0/proc_par/step_1/step_par/image/edit.png","node_type":"Image","width":1486}],"node_type":"Mixed"},{"items":[{"data":[],"node_type":"Text","text":"Do any of the following:"},{"items":[{"data":[{"id":"<id_0>","text":"Move","type":"option"},{"height":16,"id":"<id_1>","type":"img","url":"https://helpx.adobe.com/content/dam/help/icons/Cursor_Grow_Away.png","width":16}],"node_type":"Text","text":"Place the pointer over the line of the bounding box (avoid the selection handles). When the cursor changes to <id_0> pointer <id_1>, drag the box to the desired location. Hold down the Shift key as you drag to constrain the movement vertically or horizontally."}],"name":"Move","node_type":"Variable"},{"caption":"","height":287,"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/edit-text-pdfs/jcr_content/main-pars/accordion_container_/accordion-par/accordion-item-2/accordion-item-par/procedure/proc_par/step_2/step_par/image/move-sm.png","node_type":"Image","width":454},{"items":[{"data":[{"id":"<id_0>","text":"Rotation","type":"option"},{"height":23,"id":"<id_1>","type":"img","url":"https://helpx.adobe.com/content/dam/help/icons/Cur_ObjectRotate.png","width":23}],"node_type":"Text","text":"Click and hold the <id_0> pointer <id_1>, drag in the direction you want it to rotate."}],"name":"Rotate","node_type":"Variable"},{"caption":"","height":404,"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/edit-text-pdfs/jcr_content/main-pars/accordion_container_/accordion-par/accordion-item-2/accordion-item-par/procedure/proc_par/step_2/step_par/image_0/rotate-sm.png","node_type":"Image","width":454},{"items":[{"data":[],"node_type":"Text","text":"Place the pointer over any of the circular selection handles, and drag the handle to resize the text block."}],"name":"Resize","node_type":"Variable"},{"caption":"","height":306,"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/edit-text-pdfs/jcr_content/main-pars/accordion_container_/accordion-par/accordion-item-2/accordion-item-par/procedure/proc_par/step_2/step_par/image_1/resize-sm.png","node_type":"Image","width":454}],"node_type":"Mixed"}]}],"node_type":"Mixed"}],"title":"Move, rotate, or resize a text box"},{"contents":[{"data":[{"id":"<id_0>","text":"Comment tool","type":"strong"},{"id":"<id_1>","text":"Highlight, strikethrough, or underline text","type":"anchor","url":"https://helpx.adobe.com/content/help/en/acrobat/using/mark-text-edits.html#highlight_strikethrough_or_underline_text"}],"node_type":"Text","text":"If you want to mark up selected text with highlight, strikethrough, or underline, use the <id_0>. The actual text doesn\'t change in the PDF. Those mark ups only indicate where and how the text should be edited in the source file. For more information, see <id_1>."}],"title":"Highlight, strikethrough, or underline text"},{"contents":[{"data":[{"id":"<id_0>","text":"Sticky Note tool","type":"option"},{"id":"<id_1>","text":" For more information, see ","type":"option"},{"id":"<id_2>","text":"Use annotation and drawing markup tools to add comments in PDFs","type":"anchor","url":"https://helpx.adobe.com/content/help/en/acrobat/using/commenting-pdfs.html#annotations_and_drawing_markup_tools_overview"},{"id":"<id_3>","text":". ","type":"option"},{"id":"<id_4>","type":"br"}],"node_type":"Text","text":"You can use annotation and drawing markup tools to add comments. Comments are notes and drawings that communicate ideas or provide feedback for PDFs. You can type a text message using the <id_0>. Alternatively, you can use a drawing tool to add a line, circle, or other shape and then type a message in the associated pop-up note.<id_1><id_2><id_3><id_4>"}],"title":"Add annotations and drawing markups"},{"contents":[{"items":[{"data":[],"node_type":"Text","text":"You can add items to a numbered or bulleted list, create list items, convert a paragraph to a list item, and conversely. You can also change list types."},{"node_type":"Procedure","steps":[{"items":[{"data":[{"id":"<id_0>","text":"Text","type":"option"},{"id":"<id_1>","text":"Add Content","type":"option"}],"node_type":"Text","text":"From the Edit panel, select <id_0> under <id_1>."},{"data":[],"node_type":"Note","paragraphs":[{"data":[],"node_type":"Text","text":"Acrobat detects paragraphs and lists separately. Therefore, both paragraph and list may appear in the same bounding box while editing. After you save or save as the changed file and reopen it, the paragraph and list items are displayed in separate bounding boxes."}],"title":"Note:","type":"note"}],"node_type":"Mixed"},{"items":[{"items":[{"data":[],"node_type":"Text","text":"Do the following:"},{"data":[],"node_type":"Text","text":"To add or remove items from a numbered or bulleted list:"},{"items":[{"data":[{"id":"<id_0>","text":"Enter","type":"option"},{"id":"<id_1>","text":"Backspace","type":"option"}],"node_type":"Text","text":"You can add or remove items to the list at all nested levels using the same familiar controls that you use in Microsoft® Office. For example, press <id_0> at the end of a list item to insert a new row. Press <id_1> to remove the new row and position the cursor back to the end of the previous list item."}],"node_type":"UnorderedList"}],"node_type":"Mixed"},{"items":[{"data":[],"node_type":"Text","text":"To create a numbered or bulleted list:"},{"items":[{"data":[],"node_type":"Text","text":"Place the cursor in the document at the location where you want to add a list."},{"data":[{"id":"<id_0>","text":"Format Text","type":"option"}],"node_type":"Text","text":"Choose the appropriate list type under <id_0>."}],"node_type":"OrderedList"},{"data":[],"node_type":"Text","text":"To convert an existing paragraph to a list item:"},{"items":[{"data":[{"id":"<id_0>","text":"Format Text","type":"option"}],"node_type":"Text","text":"Place the cursor in the paragraph, and then choose the appropriate list type under <id_0>."}],"node_type":"UnorderedList"},{"data":[],"node_type":"Text","text":"To convert an existing list item to a paragraph:"},{"items":[{"data":[{"id":"<id_0>","text":"Format Text","type":"option"}],"node_type":"Text","text":"Select all items in the list. The appropriate list type is highlighted under <id_0>."},{"data":[],"node_type":"Text","text":"Click the highlighted list type."}],"node_type":"OrderedList"},{"data":[],"node_type":"Text","text":"To convert from one list type to another:"},{"items":[{"data":[],"node_type":"Text","text":"Place the cursor in the list item or select all items."},{"data":[{"id":"<id_0>","text":"Format Text","type":"option"}],"node_type":"Text","text":"Choose the appropriate list type under <id_0>."}],"node_type":"OrderedList"}],"node_type":"Mixed"},{"caption":"Formatting options in the right pane","height":396,"link":"https://helpx.adobe.com/content/dam/help/en/acrobat/using/modern-viewer/Format-Options.png","node_type":"Image","width":387},{"data":[],"node_type":"Note","text":"Use the keyboard to add a list item. For example, before a paragraph, you can type number ‘a’ followed by the closing parenthesis ‘)’ and then add one space. It adds a numbered list starting with “a)”.","title":"Note:","type":"note"}],"node_type":"Mixed"}]}],"node_type":"Mixed"}],"title":"Add or edit lists"}]},{"node_type":"SectionTitle","text":"Edit a PDF form","anchorId":"edit-form"},{"node_type":"Accordion","items":[{"contents":[{"data":[{"id":"<id_0>","text":"Fill and sign your PDF form","type":"anchor","url":"https://helpx.adobe.com/content/help/en/acrobat/using/fill-and-sign.html#fill_your_PDF_form"}],"node_type":"Text","text":"You can use the Fill & Sign tools to add text and other symbols anywhere on the form. For instructions, see <id_0>."}],"title":"Add, edit, or move text in a PDF form"},{"contents":[{"data":[{"id":"<id_0>","text":"PDF forms help","type":"anchor","url":"https://helpx.adobe.com/content/help/en/acrobat/using/pdf-forms.html"}],"node_type":"Text","text":"You can create, distribute, track, fill, and sign PDF forms using Acrobat. For more information, see <id_0>."}],"title":"Create or modify a PDF form"}]},{"node_type":"SectionTitle","text":"Rotate, move, delete, extract, or renumber PDF pages","anchorId":"RotatemovedeleteextractorrenumberPDFpages"},{"node_type":"Text","text":"You can easily organize pages in a PDF if you have permission to <id_0>. For more information, see <id_1>.","data":[{"id":"<id_0>","type":"anchor","text":"edit the PDF","url":"https://www.adobe.com/acrobat/online/pdf-editor.html"},{"id":"<id_1>","type":"anchor","text":"Rotate, move, delete, extract, or renumber PDF pages","url":"https://helpx.adobe.com/content/help/en/acrobat/using/manipulating-deleting-renumbering-pdf-pages.html"}]},{"node_type":"SectionTitle","text":"Update headers, footers, background, or watermarks","anchorId":"headers-footers"},{"node_type":"Accordion","items":[{"contents":[{"data":[{"id":"<id_0>","text":"Add headers, footers, and Bates numbering to PDFs","type":"anchor","url":"https://helpx.adobe.com/content/help/en/acrobat/using/add-headers-footers-pdfs.html"},{"id":"<id_1>","type":"br"}],"node_type":"Text","text":"Acrobat lets you add a header and footer throughout a PDF. Headers and footers can include a date, automatic page numbering, Bates numbers for legal documents, or the title and author. For more information, see <id_0>.<id_1>"}],"title":"Add or update headers and footers"},{"contents":[{"data":[{"id":"<id_0>","text":"Add backgrounds to PDFs","type":"anchor","url":"https://helpx.adobe.com/content/help/en/acrobat/using/add-backgrounds-pdfs.html"}],"node_type":"Text","text":"You can selectively apply a background to only specific pages or page ranges in one or more PDFs. A PDF supports only one background per page, but the backgrounds can vary from page to page. For more information, see <id_0>."}],"title":"Add, replace, or edit a background"},{"contents":[{"data":[{"id":"<id_0>","text":"Add watermarks to PDFs","type":"anchor","url":"https://helpx.adobe.com/content/help/en/acrobat/using/add-watermarks-pdfs.html"}],"node_type":"Text","text":"A watermark is a text or an image that appears either in front of or behind existing document content, like a stamp. For example, you could apply a “Confidential” watermark to pages with sensitive information. You can add multiple watermarks to one or more PDFs, but you must add each watermark separately. For more information, see <id_0>."}],"title":"Add watermarks"}]}],"anchors":["watch","edit-text","edit-form","RotatemovedeleteextractorrenumberPDFpages","headers-footers"],"coachmarks":{"menus":[],"tools":[]}},"ids":{"help_json":{"live":"702c146b-fdd1-3608-9d68-595a8cd07c3c","versions":[1]}}},"aem_id":"acrobat/using/edit-text-pdfs","metadata":{"formatVersion":"1.0","descriptions":{"long":"Learn how to add or replace text, correct typos, change fonts and typeface, adjust alignment, and resize text in a PDF using Acrobat."},"media_types":[],"published_on":"2023-04-11T16:25:43.324Z","creative_fields":[],"application":{"fi_code":"acrobat_dc_pro","sap_code":"ACRO"},"locale":"en_US","title":"Edit text in PDFs","platforms":["help_using"],"related_applications":{"fi_code":[],"sap_code":[]},"relatedUtuts":[],"level":"any","source":{"third_party":false,"label":"Adobe.com"},"topics":["introduction"],"urls":{"helpx":"https://helpx.adobe.com/acrobat/using/edit-text-pdfs.html","helpx_iframe":"https://helpx.adobe.com/acrobat/using/edit-text-pdfs.cc-home.html"}},"urls":{"helpx":"https://helpx.adobe.com/acrobat/using/edit-text-pdfs.html","helpx_iframe":"https://helpx.adobe.com/acrobat/using/edit-text-pdfs.cc-home.html"},"created_on":"2023-04-26T08:21:41.503Z","modified_on":"2023-04-26T09:02:29.955Z","locale":"en_US","published_status":"live","tutorialUUID":"2ec8e94f-9d51-3ded-9d40-bc6bf652a03a"}],"per_page":50,"page":1,"total_objects":1}')}}]);